<?php
session_start();
require 'db.php';

if (!isset($_SESSION['usuario_id'])) {
    header("Location: index.php");
    exit;
}

// Importação de Excel
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['excel'])) {
    require 'importar.php';
}

// Buscar todos os leads
$stmt = $pdo->query("SELECT * FROM leads");
$leads = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Dashboard</title>
</head>
<body>
    <h2>Lista de Leads</h2>
    <form method="POST" enctype="multipart/form-data">
        <label>Importar Excel:</label>
        <input type="file" name="excel" accept=".xls,.xlsx"><br>
        <button type="submit">Importar</button>
    </form>

    <table border="1">
        <tr>
            <th>ID</th>
            <th>Nome/Empresa</th>
            <th>Email</th>
            <th>Ações</th>
        </tr>
        <?php foreach ($leads as $lead): ?>
        <tr>
            <td><?= $lead['id'] ?></td>
            <td><?= $lead['nombre_empresa'] ?></td>
            <td><?= $lead['mail'] ?></td>
            <td><a href="atender.php?id=<?= $lead['id'] ?>">Atender</a></td>
        </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>