<?php
session_start();
require 'db.php';

if (!isset($_SESSION['usuario_id'])) {
    header("Location: index.php");
    exit;
}

$lead_id = $_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM leads WHERE id = :id");
$stmt->execute(['id' => $lead_id]);
$lead = $stmt->fetch();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $mensagem = $_POST['mensagem'];
    $meio_contato = $_POST['meio_contato'];

    $stmt = $pdo->prepare("INSERT INTO historico_atendimentos (lead_id, mensagem, meio_contato) VALUES (:lead_id, :mensagem, :meio_contato)");
    $stmt->execute(['lead_id' => $lead_id, 'mensagem' => $mensagem, 'meio_contato' => $meio_contato]);

    echo "<p style='color:green;'>Atendimento registrado com sucesso!</p>";
}

// Buscar histrico de atendimentos
$stmt = $pdo->prepare("SELECT * FROM historico_atendimentos WHERE lead_id = :lead_id ORDER BY data_atendimento DESC");
$stmt->execute(['lead_id' => $lead_id]);
$historico = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Atender Lead</title>
</head>
<body>
    <h2>Atender Lead</h2>
    <p><strong>Nome/Empresa:</strong> <?= $lead['nombre_empresa'] ?></p>
    <p><strong>Email:</strong> <?= $lead['mail'] ?></p>

    <h3>Novo Atendimento</h3>
    <form method="POST">
        <label>Mensagem:</label><br>
        <textarea name="mensagem" required></textarea><br>
        <label>Meio de Contato:</label>
        <select name="meio_contato" required>
            <option value="telefone">Telefone</option>
            <option value="email">Email</option>
            <option value="whatsapp">WhatsApp</option>
        </select><br>
        <button type="submit">Salvar</button>
    </form>

    <h3>Histrico de Atendimentos</h3>
    <ul>
        <?php foreach ($historico as $registro): ?>
        <li>
            <strong><?= $registro['data_atendimento'] ?>:</strong> <?= $registro['mensagem'] ?> (<?= $registro['meio_contato'] ?>)
        </li>
        <?php endforeach; ?>
    </ul>
</body>
</html>